<?php

namespace Models\Stats;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Flight extends Model 
{

    protected $table = 'stats_flight';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function routes()
    {
        return $this->hasMany('Models\Stats\Flight\Route', 'flight_id', 'flight_id');
    }

    public function posreps()
    {
        return $this->hasMany('Models\Stats\Flight\Posrep', 'flight_id', 'flight_id');
    }

    public function account()
    {
        return $this->belongsTo('Models\Mship\Account', 'account_id', 'account_id');
    }

}